capture log close
clear all
macro drop _all
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\DNSP 2025 benchmarking\Stata files\TFP Analysis\Data management"
set more off
log using Outputs/log/crDNSPbench25-state, replace text

/*--------------------------------------------------------------------------
Project: Quantonomics  DNSP Benchmarking
Author:  Michael Cunningham
File:    crDNSPbench25-state.do
Initial Date:    20-May-2022
Revised Date:	 22-May-2025
--------------------------------------------------------------------------*/

local varlist revenue energy ratchetmd customers circlength cmos ///
	price_cmos opex price_opex overheadst overheadd undergrst undergrd ///
    transform auc_overheadst auc_overheadd auc_undergrst auc_undergrd  ///
	auc_transform maxdemand mdindex 	

local datfiles DACTdata.csv DNSWdata.csv DVICdata.csv DQLDdata.csv ///
	DSAdata.csv DTASdata.csv 
	
***	Read data ********
	
import excel using "Input/DNSP consolidated benchmarking data (2024).xlsx", ///
	sheet("Shazam State Data") cellrange(B1:Y116) clear firstrow case(l) 
drop in 1
destring, replace	

***	Create state identifier ********

gen int state = 1
replace state = cond(year == 2006,state[_n-1]+1,state[_n-1]) if _n > 1

label define statelab 1 "ACT" 2 "NSW" 3 "VIC" 4 "QLD" 5 "SA" 6 "TAS"
label values state statelab

***	Rename variables ********	
	
rename totalrevenue                   revenue
rename customernumbers                customers	
rename maximumdemand                  maxdemand
rename ratchetedmaximumdemand         ratchetmd
rename circuitlength                  circlength	
rename customerminutesoffsupply       cmos	
rename pricecustomerminutesoffsuppl   price_cmos 	
rename priceopex                      price_opex	
rename overheadsubtransmissionlines   overheadst 	
rename overheaddistributionlinesund   overheadd
rename undergroundsubtransmissionline undergrst
rename undergrounddistributionlines   undergrd
rename transformersexcludingfirststa  transform
rename aucoverheadsubtransmission     auc_overheadst
rename aucoverheaddistribution        auc_overheadd
rename aucundergroundsubtransmission  auc_undergrst
rename aucundergrounddistribution     auc_undergrd
rename auctransformersexcludingfirst  auc_transform
rename md		 					  mdindex	

***	Misc data management & save ********

drop redundancies x
format %14.0g `varlist'

gen idyear = 4000 + state*100 + year - 2000
list idyear in 1/20
list idyear in 71/90

tab1 state year
describe, f
summarize `varlist'
misstable summarize `varlist'

save Outputs/dta/dnspbench25-state, replace

*** Create individual State & pooled State Shazam input data files ********

local j = 1	
foreach k of local datfiles {
	outsheet year `varlist' using Outputs/csv/`k' if state == `j', comma replace
	local ++j
}

outsheet idyear `varlist' using Outputs/csv/STATEdata.csv, comma replace

log close
exit

